% Post-Processing File for Series HEV Model
Time = Vehicle_Speed_mph_str.time;
Vehicle_Speed_mph = Vehicle_Speed_mph_str.signals.values;


%MPGGE Calculations using Fuel heating values provided 
% by Argonne National Lab (ANL).
Fuel_Heating_Value_B20 = 133393.1102; % BTU/gal (Provided by ANL)
Fuel_Heating_Value_RFG = 114871.7446; % BTU/gal (Provided by ANL)
Conversion_Efficiency = 0.25; % (Provided by ANL)

%Fuel Calculations using ANL values for fuel weight per gallon
Fuel_Consumed = Engine_Fuel_Consumed_g(end); % Grams
Fuel_Consumed_B20_Gallons = Fuel_Consumed/3215; % Based 
% on 7.088591254 lbs per gallon provided by ANL.
Distance_Traveled = Distance_Miles(end);% Miles

%Plot the measured battery V-I curve
plot( Battery_Current_A, Battery_Voltage_V);
xlabel('Current (A)');
title('Battery VI Characteristic');
ylabel('Voltage (V)');
grid on;

%Calculate the battery open circuit voltage from the battery IV plot.
poly=polyfit(Battery_Current_A, Battery_Voltage_V,1);
Battery_OCV = poly(2); %in Volts


%Calculate the electrical Energy 
delta_SOC = Battery_SOC(end)-Battery_SOC_Init;
Amp_Hours_Consumed = delta_SOC*Battery_AH_Rating;
Electrical_Energy = Amp_Hours_Consumed*Battery_OCV; %(Watt-Hours)
Electrical_Energy_BTU = (Electrical_Energy/Conversion_Efficiency)*3.412; %W-Hr to BTU

%Calcualte the energy contained in the fuel consumed.
Fuel_Energy_BTU = Fuel_Consumed_B20_Gallons*Fuel_Heating_Value_B20;

% Calcualte the total energy conumed in BTUs.
%Energy out of pack is negative, so we add it to the total fuel consumed.
Total_Energy_Consumed_BTU = Fuel_Energy_BTU-Electrical_Energy_BTU; 

% Calculatethe amount of RFG that would be necessary to supply 
% the same amount of energy consumed by the vehicle.
Fuel_Consumed_RFG_Gal = Total_Energy_Consumed_BTU/Fuel_Heating_Value_RFG;

%Calculate the feeiciency, miles per gallon gas equivalent, with state of
%charge correction.
MPGGE_RFG_wSOC = Distance_Traveled/Fuel_Consumed_RFG_Gal;




msg1=sprintf('                Results of Vehicle Simulation\n\n');
msg2=sprintf('---------------------------------------------------------------------------\n');
msg3=sprintf('Cycle name: %s\n---------------------------------------------------------------------------\n\n',fn);

msg4=sprintf('Total distance traveled = %g miles.\n', Distance_Traveled);
msg5=sprintf('Amount of fuel consumed = %g grams of B20.\n', Fuel_Consumed);
msg6=sprintf('\nMPG Calculations based on ANL Calculations\n--------------------------------\n');
msg7=sprintf('MPGGE with SOC Correction = %g.\n', MPGGE_RFG_wSOC);
msg8=sprintf('\n---------------------------------------------------------------------------\n');
msg9=sprintf('Calculated Battery Open Circuit Voltage = %g V.\n', Battery_OCV);


msg=[msg1,msg2, msg3, msg4,msg5, msg6, msg7, msg8, msg9];
Title=['Schedule File: ', fn];
h=msgbox(msg, Title);


