class SRV extends SkidSteeredRobot config(USARBot);

defaultproperties
{
  //---Wheel information.  Since the SRV has four wheels, we have four of these definitions
  // The next four definitions will create a 4-wheel skid steer SRV where all the wheels are locked (cannot be steered)

    // Number=0 indicates that this wheel is the first JointPart defined in USARBot.ini (ORDER MATTERS!)
    // Power=Right_Powered tells USARSim to spin this wheel using the right throttle
    // Note that since the variables SteerType and MaxSteerAngle are not defined, this wheel is not steered (steering is locked)
    Wheels(0)=(Number=0,PowerType=Right_Powered);

    // Number=1 indicates that this wheel is the second JointPart defined in USARBot.ini (ORDER MATTERS!)
    // Power=Left_Powered tells USARSim to spin this wheel using the left throttle
    // Note that since the variables SteerType and MaxSteerAngle are not defined, this wheel is not steered (steering is locked)
    Wheels(1)=(Number=1,PowerType=Left_Powered);

    // Number=2 indicates that this wheel is the third JointPart defined in USARBot.ini (ORDER MATTERS!)
    // Power=Left_Powered tells USARSim to spin this wheel using the right throttle
    // Note that since the variables SteerType and MaxSteerAngle are not defined, this wheel is not steered (steering is locked)
    Wheels(2)=(Number=2,PowerType=Right_Powered);

    // Number=3 indicates that this wheel is the fourth JointPart defined in USARBot.ini (ORDER MATTERS!)
    // Power=Left_Powered tells USARSim to spin this wheel using the left throttle
    // Note that since the variables SteerType and MaxSteerAngle are not defined, this wheel is not steered (steering is locked)
    Wheels(3)=(Number=3,PowerType=Left_Powered);
  //---

  //--Other Robot's Properties
    bDebug=false
    StaticMesh=StaticMesh'SASLab_Meshes.SRV.SRVBody'
    DrawScale=4.762
    DrawScale3D=(X=1.0,Y=1.0,Z=1.0)

    ChassisMass=1.000000
    
    // Configuration Parameters. Note: these variables need to be correspond to your robot's model.
    WheelRadius=0.026                        // Wheel Radius, in unreal units. Note: Value is in meters
    Dimensions=(X=0.11,Y=0.062,Z=0.08)      // X=Length=0.11m, Y=Width=0.062m, Z=Height=0.08m
    maxSpinSpeed=21.15                     // Maximum wheel's spin speed is max_tran_speed/wheel_radius=0.7/0.13=5.385

    TireRollFriction=15.000000
    TireLateralFriction=15.000000
    TireRollSlip=0.0600
    TireLateralSlip=0.0600000
    TireMinSlip=0.005000
    //TireSlipRate=0.00050000
    TireSlipRate=0.0050000
    //TireSlipRate=0.050000 // for experiment!
    TireSoftness=0.000020
    TireAdhesion=0.000000
    TireRestitution=0.000000

    Begin Object Class=KarmaParamsRBFull Name=KParams0
        bKNonSphericalInertia=True
        KInertiaTensor(0)=0.0156
        KInertiaTensor(3)=0.0093
        KInertiaTensor(5)=0.0225
        KCOMOffset=(X=0.000000,Z=0.000000)
        KActorGravScale=2.58
        KLinearDamping=0
        KAngularDamping=0
        KMaxAngularSpeed=100
        KMaxSpeed=2500
        KStartEnabled=True
        bHighDetailOnly=False
        bClientOnly=False
        bKDoubleTickRate=True
        KFriction=0.9
        Name="KParams0"
    End Object
    KParams=KarmaParamsRBFull'USARBot.SRV.KParams0'
  //--
}