% Rotate a 2D point p by theta radians about an axis perpendicular to 
% the plane p lies on.
function rp = rotate(p, theta)
    c = cos(theta);
    s = sin(theta);
    if size(p,1) == 1 % If the user gives us a row-vector, we'll deal with it
        p = reshape(p, 2, 1);
    end
    mat = [c, -s;
           s,  c];
    rp = mat * p;