function show_sim(start, goal, current_p)
    positions = simulator(current_p', start', goal');
    diffs = repmat(goal, size(positions,1), 1) - positions;
    traj_direction = goal - start;
    traj_direction = traj_direction./norm(traj_direction);
    
    dists_to_goal = zeros(1,size(diffs,1));
    cross_track_errors = zeros(size(dists_to_goal));
    
    for i = 1:size(diffs,1)
        dists_to_goal(i) = norm(diffs(i,:));
        p_shifted = positions(i,:) - start;
        distance_traveled = norm(p_shifted);
        pn = p_shifted / distance_traveled;
        projected_point = dot(pn, traj_direction) * distance_traveled * ...
                          traj_direction;
        cross_track_errors(i) = norm(projected_point - p_shifted);
    end
    
    figure(1);
    plot(dists_to_goal);
    title('Distance to Goal');
    
    figure(2);
    plot(start(1), start(2), 'go');
    hold on;
    plot(goal(1), goal(2), 'rd');
    plot(positions(:,1), positions(:,2));
    title('Robot Trajectory');
    hold off;
    axis equal
    
    figure(3);
    plot(cross_track_errors);
    title('Cross-track Error');
    
    