function task1_mah349(inputfile)

% initializes the figure window
figure (1)
clf
axis([-5 5 -5 5]);

% prompts the user to select a starting position for the robot
disp('Select an initial start position for your robot.')
[xStart, yStart] = ginput(1);               % allows you to select a point in the figure window by clicking on it

% reads in the robot centric accelerations and angular velocities from
% input file
[xRAccel, yRAccel, zROmega] = textread(inputfile, '%f%f%f');

% initializes the integration time step and robot speed
dt = 0.02;              % integration time step
v = 0;                  % robot's initial speed

% fixes the range of the axes on the figure
axis([-5 xStart+13 -5 yStart+13])
hold on

% the sensors give back the x and y acceleration plus the thetadot info.
% This means that the position data can be updated by integrating the
% accelerations and velocities accordingly

% robot's pose in the world coordinate frame
xW = xStart;
yW = yStart;
thetaW = 0;	

rob = makeRobot(xW, yW, thetaW);
for i = 1:length(xRAccel)
    
    theta = rob.theta + zROmega(i)*dt;
    v = v + xRAccel(i)*dt;
    
    x = rob.x + v*cos(theta)*dt;
    y = rob.y + v*sin(theta)*dt;
    
    rob = moveRobot(rob, x, y, theta);
    
    % uncomment this if you want to see an animation
    pause(.001);
end
drawRobot(rob, 0.5, 'r')