% Copyright (c) 2017, Domenico L. Gatti
% All rights reserved.
% 
% Redistribution and use in source and binary forms, with or without 
% modification, are permitted provided that the following conditions are 
% met:
% 
%     * Redistributions of source code must retain the above copyright 
%       notice, this list of conditions and the following disclaimer.
%     * Redistributions in binary form must reproduce the above copyright 
%       notice, this list of conditions and the following disclaimer in 
%       the documentation and/or other materials provided with the 
%       distribution
%       
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
% IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
% PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
% CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
% EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
% PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
% PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
% LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
% NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
% SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
%
%% General dependencies
% We always start from the CODE directory and we add to the path
% subdirectories containing various tools described in the book chapters.
% Prior to running the following lines of code install the Toolboxes:
% COBRA (https://www.mathworks.com/matlabcentral/linkexchange/links/3050)
% FastICA (http://research.ics.aalto.fi/ica/fastica/) 
% RADICAL (http://people.cs.umass.edu/~elm/ICA/) 
% MetaTool (http://pinguin.biologie.uni-jena.de/bioinformatik/networks/metatool/metatool5.1/metatool5.1.html)
% in the TOOLBOXES directory, and add them to your path using 'addpath', i.e.:
% addpath(genpath('../TOOLBOXES/FastICA'))
% addpath(genpath('../TOOLBOXES/RADICAL'))
% addpath(genpath('../TOOLBOXES/cobratoolbox'));
% addpath(genpath('../TOOLBOXES/MetaTool'));

addpath(genpath('../GENERAL_SCRIPTS_FUNCTIONS'));
addpath(genpath('../DATABASE'));

%% CHAPTER 19: Metabolic Network Reconstruction, Flux Balance Analysis.

%% Dynamic simulation of Erythrocyte Metabolism
%
open ../TUTORIALS/ERYTHROCYTE_METABOLISM/Erythrocyte_Metabolism_Practice.m
%
%% FBA analysis of E. coli core metabolism
% Gurobi activation
cd /Library/gurobi702/mac64/matlab
gurobi_setup
cd ../TOOLBOXES/cobratoolbox-master
initCobraToolbox()

cd ../../CODE

% A MATLAB tutorial
% (https://www.nature.com/protocolexchange/protocols/2097) from the
% article: Becker, S. et al., "Quantitative prediction of cellular
% metabolism with constraint-based models: The COBRA Toolbox", Nat. Protoc
% 2, 727-738 (2007), can be used to analyze E. coli core metabolism with
% the COBRA Toolbox. After saving the tutorial file in your TUTORIALS
% directory, for example as 'ECOLI_CORE_FBA_COBRA.m', execution of the
% script cell by cell provides a review of additional types of COBRA
% analysis not discussed in this chapter:
% 
% a. Growth on alternate substrates.
% b. Alternate optimal solutions - Flux Variability Analysis (FVA).
% c. Double gene deletions.
% d. Identification of essential genes for biomass production.
% e. Metabolites connectivity and reaction essentiality.
% f. Random sampling.

% Load the simplified E. coli model.
model = readCbModel('../TOOLBOXES/cobratoolbox/test/additionalTests/testMaps/ecoli_core_model.mat');
default_model = model;

% Load the simplified E. coli map.
map = readCbMap('../TOOLBOXES/cobratoolbox/test/additionalTests/testMaps/ecoli_core_map.txt');

% If readCbMap is called with no arguments, a dialog box will prompt the
% user to select a map file. After the map has been read into MATLAB, it
% can be viewed as a MATLAB figure or a scalable vector graphic (svg). To
% view a map as a MATLAB figure the following commands are used

changeCbMapOutput('matlab');
drawCbMap(map);
colorbar('off')
ax = gca;
ax.Visible = 'off';

% Start the tutorial
open ../TUTORIALS/ECOLI_CORE_FBA_COBRA.m

