% Copyright (c) 2017, Domenico L. Gatti
% All rights reserved.
% 
% Redistribution and use in source and binary forms, with or without 
% modification, are permitted provided that the following conditions are 
% met:
% 
%     * Redistributions of source code must retain the above copyright 
%       notice, this list of conditions and the following disclaimer.
%     * Redistributions in binary form must reproduce the above copyright 
%       notice, this list of conditions and the following disclaimer in 
%       the documentation and/or other materials provided with the 
%       distribution
%       
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
% IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
% PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
% CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
% EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
% PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
% PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
% LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
% NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
% SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
%
%% General dependencies
% We always start from the CODE directory and we add to the path
% subdirectories containing various tools described in the book chapters.
addpath(genpath('../GENERAL_SCRIPTS_FUNCTIONS'));
% addpath(genpath('../DATABASE'));
% addpath(genpath('../TOOLBOXES'));

%% CHAPTER 1 CODE. The fundamental ideas of linear algebra.

% we clear the workspace and its history
clear
clc

a = [1 ; 3 ; 6];
a = [1 3 6]; 

a = [1 ; 3 ; 6];
a = a';  

v1 = [1 0 0]';
v2 = [0 1 0]';
v3 = [0 0 1]';
v1'*v2
v1'*v3
v2'*v3

% Norm of vectors
format long
a = [3; 5 ;1] , b = [3 -2 1]' 
a'*b
sum(a.*b)
sqrt(a'*a)
norm(a)
length(a)
size(a)

norm(v1), norm(v2), norm(v3)

% Unit vectors
a
a/norm(a)
norm(a/norm(a))

% Angle between vectors
b = [2 6 0]'
cos_theta = a'*b/(norm(a)*norm(b))
theta_rads = acos(cos_theta)
theta_deg = (180/pi)*theta_rads
theta_deg = acosd(cos_theta)

% Matrix dot product
A = [1 2;3 4]
B = [5 6;7 8]
C = A*B
D = B*A

%% SPECIAL TOPICS: Other types of products between vectors or matrices.

% Diadic product
C = a*b'
D = b*a'
D = (a*b')'

% Kronecker tensor product
A = [3 1;-2 4]
B = [3 5;0 2]
C = kron(A,B)
C^(-1)
kron(A^(-1),B^(-1))
C'
kron(A',B')

A = eye(4); 
B = [1 -1;-1 1];
K = kron(A,B)

% Double dot product
c = sum(a.*b)
c = sum(b.*a)
c = b'*a
c = a'*b

A = [9 -6 3;15 -10 5;3 -2 1]
B = A'
C = A*B
D = B*A

C = A.*B
C = B.*A
c = sum(sum(C))
c = sum(C(:))
c = A(:)'*B(:)

% Cross product
c = cross(a,b)
d = cross(b,a)

% Triple product
A = [9 -6 3;15 5 5;3 -2 2]
volA = (cross(A(:,1),A(:,2)))'*A(:,3)
volA = dot(cross(A(:,1),A(:,2)), A(:,3))
volA = det(A)

u1 = A(1,1)
u2 = A(2,1)
u3 = A(3,1)
v1 = A(1,2)
v2 = A(2,2)
v3 = A(3,2)
w1 = A(1,3)
w2 = A(2,3)
w3 = A(3,3)
volA = u1*(v2*w3-v3*w2)-v1*(u2*w3-u3*w2)+w1*(u2*v3-u3*v2)

% p-norm of vectors
a = [3 -5 1];
norm_3 = (abs(a(1))^3 + abs(a(2))^3 + abs(a(3))^3)^(1/3)
norm_3 = norm(a,3)

norm_pinf = max(abs(a))
norm_pinf = norm(a,Inf)
norm_minf = min(abs(a))
norm_minf = norm(a,-Inf)

% p-norm of matrices
A = [1 2 3;0 4 1;5 3 2;7 1 1]

norm_1 = max(sum(abs(A)))
norm_2 = max(svd(A))
norm_1 = norm(A,1)
norm_2 = norm(A,2)

norm_pinf = max(sum(abs(A')))
norm_pinf = norm(A',1)
norm_pinf = norm(A,Inf)

% Frobenius norm of matrices
norm_fro = sqrt(sum(diag(A'*A)))
norm_fro = norm(A,'fro')
norm_fro = norm(A(:))

