% Copyright (c) 2017, Domenico L. Gatti
% All rights reserved.
% 
% Redistribution and use in source and binary forms, with or without 
% modification, are permitted provided that the following conditions are 
% met:
% 
%     * Redistributions of source code must retain the above copyright 
%       notice, this list of conditions and the following disclaimer.
%     * Redistributions in binary form must reproduce the above copyright 
%       notice, this list of conditions and the following disclaimer in 
%       the documentation and/or other materials provided with the 
%       distribution
%       
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
% IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
% PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
% CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
% EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
% PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
% PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
% LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
% NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
% SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
% 

%% General dependencies
addpath(genpath('../GENERAL_SCRIPTS_FUNCTIONS'));
addpath(genpath('../DATABASE'));

%% CHAPTER 1 PRACTICE.

% 1. Find 5 independent vectors perpendicular to the vector a = [3 5 1].
% Show their independence by calculating the cosine of the angle between
% all the pairwise combinations of the 5 vectors.

a = [3 5 1]

b = [2 0 -6]
c = [2 -1 -1]
d = [1 -1 2]
e = [0 2 -10]
f = [-3 1 4]

a*b'
a*c'
a*d'
a*e'
a*f'

acosd((b*c')/(norm(b)*norm(c)))
acosd((b*d')/(norm(b)*norm(d)))
acosd((b*e')/(norm(b)*norm(e)))
acosd((b*f')/(norm(b)*norm(f)))
acosd((c*d')/(norm(c)*norm(d)))
acosd((c*e')/(norm(c)*norm(e)))
acosd((c*f')/(norm(c)*norm(f)))
acosd((d*e')/(norm(d)*norm(e)))
acosd((d*f')/(norm(d)*norm(f)))
acosd((e*f')/(norm(e)*norm(f)))

A = [b;c;d;e;f]'
rank(A)

% 2. Find an orthonormal basis in which the u1 basis vectors is colinear
% with the vector a of the previous problem. Then display both the standard
% and the new orthonormal basis in the same plot using the function
% 'show_frame'.

c = cross(a,b)

u1 = a/norm(a)
u2 = b/norm(b)
u3 = c/norm(c)

I = eye(3);
U = [u1;u2;u3]'
show_frame('new',I)
hold on
show_frame('add',U,'--y','--m','--c') 

% 3. Practice with matrix products. For example, given the three matrices:

A = [1 3;2 3;4 5]
B = [3 2 4 2; 4 4 1 2; 1 1 4 5]
C = [ 2 2 1 1; 1 3 1 3]

% calculate different combinations of products and try to understand why
% some of them give you an error unless you transpose one or more matrices.

A*B*C
B*A*C

% Then, based on your observations, derive a transposition law for matrix
% products. For example, derive the expression equivalent to:

(A'*B*C')' 

% that does not include a final transposition of the product inside the
% parenthesis.

C*B'*A

