% Copyright (c) 2017, Domenico L. Gatti
% All rights reserved.
% 
% Redistribution and use in source and binary forms, with or without 
% modification, are permitted provided that the following conditions are 
% met:
% 
%     * Redistributions of source code must retain the above copyright 
%       notice, this list of conditions and the following disclaimer.
%     * Redistributions in binary form must reproduce the above copyright 
%       notice, this list of conditions and the following disclaimer in 
%       the documentation and/or other materials provided with the 
%       distribution
%       
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
% IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
% PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
% CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
% EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
% PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
% PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
% LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
% NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
% SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
%
%% General dependencies
% We always start from the CODE directory and we add to the path
% subdirectories containing various tools described in the book chapters.
addpath(genpath('../GENERAL_SCRIPTS_FUNCTIONS'));
% addpath(genpath('../DATABASE'));
% addpath(genpath('../TOOLBOXES'));

%% CHAPTER 3: Matrix factorization and systems of linear equations. 

% 1. Use the two provided MATLAB functions lu_fact.m (LU factorization of
% a square matrix ) and lu_solv.m (LU based solver of systems of linear
% equation) in sequence to solve the matrix equation Ax = b, where:

A = [3 7 8;1 4 7;2 2 4];
b = [59 34 22]';

% 2. Carry out the LDL' factorization of the symmetric matrix:

A = [2 3 1;3 1 1;1 1 2];

% and show that L*U and L*D*L' give indeed the same result. 

% 3. Using code lines from lu_solv.m can you write a MATLAB program that
% will solve the matrix equation Ax = b with:

b = [5 7 3]';

% using the LDL' factorization? Remember that in this case the logical
% steps of the solution are going to be:
% 1. Ly = b
% 2. DL'x = y => L'x = y/D
% These correspond to the MATLAB commnds:

y = inv(L)*b
x = inv(L')*(inv(D)*y)


