% Copyright (c) 2017, Domenico L. Gatti
% All rights reserved.
% 
% Redistribution and use in source and binary forms, with or without 
% modification, are permitted provided that the following conditions are 
% met:
% 
%     * Redistributions of source code must retain the above copyright 
%       notice, this list of conditions and the following disclaimer.
%     * Redistributions in binary form must reproduce the above copyright 
%       notice, this list of conditions and the following disclaimer in 
%       the documentation and/or other materials provided with the 
%       distribution
%       
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
% IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
% PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
% CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
% EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
% PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
% PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
% LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
% NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
% SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
%
%% General dependencies
% We always start from the CODE directory and we add to the path
% subdirectories containing various tools described in the book chapters.
addpath(genpath('../GENERAL_SCRIPTS_FUNCTIONS'));
% addpath(genpath('../DATABASE'));
% addpath(genpath('../TOOLBOXES'));

%% CHAPTER 4: The fundamental theorem of linear algebra.
A = [2 0 2;3 1 1;1 1 1]
b = [1 2 1]
y = b*inv(A)
y*A

A = [3 1 1;1 1 1;1 2 1]
b = [2 0 2]
y = b*inv(A)
y = b/A
y*A

%
A = [-6 2 0 4;-15 5 0 10;-7 3 1 3;...
     -1 1 1 -1;1 1 2 -4;6 0 3 -9]
x = A(:,1:2)\A(:,3)
x = A(:,1:2)\A(:,4)
rank(A)
CA = orth(A)
RA = orth(A')

%
NA = null(A,'r') % rational form 
A*NA
norm(NA(:,1))
norm(NA(:,2))
NA'*NA

%
NA = null(A)
norm(NA(:,1))
norm(NA(:,2))
NA'*NA
A*NA

%
LNA = null(A','r')
LNA = null(A')
LNA'*A

%
CA = orth(A)
RA = orth(A')
NA = null(A)
LNA = null(A')

[U,S,V] = svd(A)

