function MI = mi_from_angle(phi,x12_mat)

global X_white method

if nargin == 1
    x12_mat = X_white; 
else
    x12_mat = X_white;
end

Q = [cosd(phi) sind(phi);-sind(phi) cosd(phi)];
x12_q = (Q*x12_mat);

switch method
    case 'binning'
% Using binning
[bins,edges] = internal.stats.histbins([x12_q(1,:) x12_q(2,:)]);

nbins = length(bins);

x12_binned = x12_q;

for i = 1:nbins
    ind = x12_q(1,:)>= edges(i) & x12_q(1,:)<= edges(i+1);
    x12_binned(1,ind) = i;
    ind = x12_q(2,:)>= edges(i) & x12_q(2,:)<= edges(i+1);
    x12_binned(2,ind) = i;
end

MI_mat = NMSA_to_fastMI(x12_binned');
MI = MI_mat(1,2);

    case 'ksdensity'
% Using ksdensity and reporting only rho
u = ksdensity(x12_q(1,:)',x12_q(1,:)','function','cdf');
v = ksdensity(x12_q(2,:)',x12_q(2,:)','function','cdf');
% scatterhist(u,v)
rhomat = copulafit('Gaussian',[u,v]);
% rhosq = rhomat(1,2)^2;
% MI = -0.5*log2(1-rhosq);
MI = rhomat(1,2);

    case 'ctransform'
% Using ctransform and reporting only rho
u = ctransform(x12_q(1,:));
v = ctransform(x12_q(2,:));
uv = [u' v'];
% scatterhist(u,v)
[ind1,~] = find(uv == 1);
[ind0,~] = find(uv == 0);
ind = setdiff([1:1000],[ind1;ind0]);
uv1 = uv(ind,:);
rhomat = copulafit('Gaussian',uv1);
% rhosq = rhomat(1,2)^2;
% MI = -0.5*log2(1-rhosq);
MI = rhomat(1,2);

    case 'kernelmi'
% Using kernelmi
MI = kernelmi(x12_q(1,:),x12_q(2,:));

end
