function [Q,p] = Q_from_p_and_theta_alt(p,theta)

% Find a transformation matrix that represents a rotation of the coordinate
% frame (the basis) by an angle theta around a given vector p. We will use
% a traditional formula due to Euler.

if size(p,1) == 1
    p = p';
end

p = p/norm(p);
I = eye(3);
P = [0 p(3) -p(2);-p(3) 0 p(1);p(2) -p(1) 0];
cos_theta = cos(theta);
sin_theta = sin(theta);
Q = cos_theta*I + (1-cos_theta)*(p*p') + sin_theta*P;
    

