function [R] = R_from_Euler(phi,theta,psi)
%   Calculate rotation matrix from euler angles in degrees
%   Input:  1x3 vector of rotations around x, euler_angles(1), y, 
%   euler_angles(2), and z, euler_angles(3).
%   Output: 3x3 rotation matrix

Q1 = [1 0 0; 0 cosd(phi) sind(phi);0 -sind(phi) cosd(phi)];
Q2 = [cosd(theta) 0 -sind(theta);0 1 0;sind(theta) 0 cosd(theta)];
Q3 = [cosd(psi) sind(psi) 0;-sind(psi) cosd(psi) 0;0 0 1];
Q = Q3*Q2*Q1;
R = Q';

end


