function [p,theta] = p_and_theta_from_Q_alt(Q)
% Given a transformation matrix Q find the vector p and the angle theta
% such that Q corresponds to a rotation of the coordinate frame by theta
% around p. We will work with a traditional formula due to Euler, based
% on the fact that the trace of a transformation/rotation matrix is
% invariant under similarity transformation.

theta = acos(0.5*(trace(Q)-1));

den = 2*sin(theta);
p1 = (Q(2,3)-Q(3,2))/den;
p2 = (Q(3,1)-Q(1,3))/den;
p3 = (Q(1,2)-Q(2,1))/den;

p = [p1 p2 p3]';


