function [] = show_frame(draw,Q,color1,color2,color3,...
              label1,label2,label3,linewidth)

x = Q(:,1);y = Q(:,2);z = Q(:,3);

LineWidth = 3;

if nargin == 2
    color1 = 'r';
    color2 = 'g';
    color3 = 'b';
    label1 = 'x';
    label2 = 'y';
    label3 = 'z';
elseif nargin == 5
    label1 = 'x';
    label2 = 'y';
    label3 = 'z';
elseif nargin == 9
    LineWidth = linewidth;
end

if strcmp(draw,'new')
Frames = figure('Name','Frames','Units','normalized',...
    'Position',[0.5,0.5,0.3,0.5]);
plot3([0 x(1)]',[0 x(2)]',[0 x(3)]',color1,'LineWidth',LineWidth)
hold on
plot3([0 y(1)]',[0 y(2)]',[0 y(3)]',color2,'LineWidth',LineWidth)
plot3([0 z(1)]',[0 z(2)]',[0 z(3)]',color3,'LineWidth',LineWidth);
axis equal
grid on
box on
h = get(Frames,'Children');
set(h,'XLim',[-1 1],'YLim',[-1 1],'ZLim',[-1 1],'DataAspectRatio',[1 1 1])
text(x(1)*1.1,x(2)*1.1,x(3)*1.1,label1,'FontWeight','bold','FontSize',14)
text(y(1)*1.1,y(2)*1.1,y(3)*1.1,label2,'FontWeight','bold','FontSize',14)
text(z(1)*1.1,z(2)*1.1,z(3)*1.1,label3,'FontWeight','bold','FontSize',14)
% title(sprintf('Orthogonal set made from Q'),...
%     'FontWeight','bold','FontSize',14)
else
hold on
plot3([0 x(1)]',[0 x(2)]',[0 x(3)]',color1,'LineWidth',LineWidth)
plot3([0 y(1)]',[0 y(2)]',[0 y(3)]',color2,'LineWidth',LineWidth)
plot3([0 z(1)]',[0 z(2)]',[0 z(3)]',color3,'LineWidth',LineWidth);
text(x(1)*1.1,x(2)*1.1,x(3)*1.1,label1,'FontWeight','bold','FontSize',14)
text(y(1)*1.1,y(2)*1.1,y(3)*1.1,label2,'FontWeight','bold','FontSize',14)
text(z(1)*1.1,z(2)*1.1,z(3)*1.1,label3,'FontWeight','bold','FontSize',14)
end
