function [] = show_vector(V,color,label,linewidth,linetype)

switch nargin 
    case 3
        linewidth = 3;
        LineType = '-';        
    case 4
        LineType = '-';
    case 5
        LineType = linetype; 
end

if size(V,1) == 1
    V = V';
else
end

x = V/norm(V);

plot3([0 x(1)]',[0 x(2)]',[0 x(3)]',...
    LineType,'Color',color,'LineWidth',linewidth)
text(x(1)*1.1,x(2)*1.1,x(3)*1.1,label,'FontWeight','bold','FontSize',14)
