% Copyright (c) 2015, Domenico L. Gatti
% All rights reserved.
% 
% Redistribution and use in source and binary forms, with or without 
% modification, are permitted provided that the following conditions are 
% met:
% 
%     * Redistributions of source code must retain the above copyright 
%       notice, this list of conditions and the following disclaimer.
%     * Redistributions in binary form must reproduce the above copyright 
%       notice, this list of conditions and the following disclaimer in 
%       the documentation and/or other materials provided with the 
%       distribution
%       
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
% IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
% PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
% CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
% EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
% PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
% PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
% LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
% NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
% SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
% 

function Product_sim_vector = bi_bi_fit_1(pin,Time_vector)
global m1 C_init C E E_init S1 S2 koff1 kcatf kcatr koff2 koff3 koff4 ntimes ...
    s1_conc_vec s1_cons s2_conc_vec s2_cons Product_vector_ind;
%
set(koff3,'Value',pin(1));
set(koff4,'Value',pin(2));
set(kcatr,'Value',pin(3));

%-------------------
Product_sim_mat = zeros(ntimes,s1_cons,s2_cons);

set(C,'Capacity',C_init);
set(E,'InitialAmount',E_init);

for k = 1:s2_cons
    set(S2,'InitialAmount',s2_conc_vec(k));    
    for i = 1:s1_cons
%         set(C,'Capacity',C_init);
%         set(E,'InitialAmount',E_init);        
        set(S1,'InitialAmount',s1_conc_vec(i));
        Sim_mat = sbiosimulate(m1);
        % Fill the 3D array with product values for each run.
        Product_sim_mat(:,i,k) = Sim_mat.Data(:,8);
    end
end

Product_sim_vector = Product_sim_mat(:);

Product_sim_vector = Product_sim_vector(Product_vector_ind);




