% Copyright (c) 2013, Domenico L. Gatti
% All rights reserved.
% 
% Redistribution and use in source and binary forms, with or without 
% modification, are permitted provided that the following conditions are 
% met:
% 
%     * Redistributions of source code must retain the above copyright 
%       notice, this list of conditions and the following disclaimer.
%     * Redistributions in binary form must reproduce the above copyright 
%       notice, this list of conditions and the following disclaimer in 
%       the documentation and/or other materials provided with the 
%       distribution
%       
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
% IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
% PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
% CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
% EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
% PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
% PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
% LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
% NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
% SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
% 

function Product_sim_vector = comp_inhib_fit(pin,Time_vector)
global m1 C_init C E E_init S I koff kcat ki_off ntimes ...
    conc_vec ncons i_conc_vec i_ncons;
%
set(koff,'Value',pin(1));
set(kcat,'Value',pin(2));
set(ki_off,'Value',pin(3));

%-------------------
Product_sim_mat = zeros(ntimes,ncons,i_ncons);

set(C,'Capacity',C_init);
set(E,'InitialAmount',E_init);

for k = 1:i_ncons
    for i = 1:ncons        
        set(S,'InitialAmount',conc_vec(i));
        set(I,'InitialAmount',i_conc_vec(k));    
        Sim_mat = sbiosimulate(m1);
        % Fill the 3D array with product values for each run.
        Product_sim_mat(:,i,k) = Sim_mat.Data(:,4);
    end
end

Product_sim_vector = zeros(ntimes*ncons*i_ncons,1);
for i = 1:i_ncons
    for k = 1:ncons
        for j = 1:ntimes
        Product_sim_vector(j+(k-1)*ntimes+(i-1)*ncons*ntimes,1) = Product_sim_mat(j,k,i);
        end;
    end;
end






