% Copyright (c) 2013, Domenico L. Gatti
% All rights reserved.
% 
% Redistribution and use in source and binary forms, with or without 
% modification, are permitted provided that the following conditions are 
% met:
% 
%     * Redistributions of source code must retain the above copyright 
%       notice, this list of conditions and the following disclaimer.
%     * Redistributions in binary form must reproduce the above copyright 
%       notice, this list of conditions and the following disclaimer in 
%       the documentation and/or other materials provided with the 
%       distribution
%       
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
% IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
% PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
% CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
% EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
% PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
% PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
% LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
% NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
% SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
% 

function Product_sim_vector = uni_uni_fit(pin,Time_vector)
global m1 C E S ES P kon koff kcat Time_points ntimes conc_vec ncons;
%
set(kon,'Value',pin(1));
set(koff,'Value',pin(2));
set(kcat,'Value',pin(3));

%-------------------
Product_sim_mat = zeros(ntimes,ncons);

for i = 1:ncons
    set(S,'InitialAmount',conc_vec(i));
    Sim_mat = sbiosimulate(m1);
    % Fill the 2D array with product values for each run.
    Product_sim_mat(:,i) = Sim_mat.Data(:,4);
end

Product_sim_vector = zeros(ntimes*ncons,1);
for k = 1:ncons
    for j = 1:ntimes
    Product_sim_vector(j+(k-1)*ntimes,1) = Product_sim_mat(j,k);
    end;
end;

% first_ind = 0;
% last_ind = 0;
% for i = 1:ncons
% first_ind = first_ind + 1;
% last_ind = last_ind + ntimes;
% Product_vector(first_ind:last_ind) = Product_mat(:,i);
% first_ind = last_ind;
% end




