% A -1 Finding f^'' (0)

clc; clear
% Choose Le=4.6407 for the eta domain for comparison of u profiles 
% Choose Le > 8 to obtain f''(0) = 0.332. 
Le = 10; 
ne=2000; de=Le/ne; nep=ne+1; 
for i=1:nep
    eta(i)=(i-1)*de; g(i)=0; f(i)=0; b(i)=0; 
end
g(1)=0; g(nep)=1; % introduce g to be f' 
for iter=1:12 % need to iterate because there is a nonlinear term
    a(1,1)=1; b(1)=0;
    for i=2:ne
        c1=.25*de*f(i);
        a(i,i-1)=1-c1; a(i,i)=-2; a(i,i+1)=1+c1; 
    end
    a(nep,nep)=1; b(nep)=1; 
    g=a\b'; 
    for i=2:ne
        f(i)=f(i-1)+.5*de*(g(i-1)+g(i)); % use trapezoidal rule
    end
 fppz=(-1.5*g(1)+2*g(2)-.5*g(3))/de; % 3-pt approximation
 %fprintf('%5.0f %9.4f \n', iter, fppz)% = 0.3398
end
for i=1:nep
    ksi(i)=eta(i)/Le;
    u_cubic(i)=1.5*ksi(i)-0.5*(ksi(i))^3; 
    if(i==1); fpp(i)=fppz; 
    elseif(i==nep); fpp(i)=0;
    else fpp(i)=(g(i+1)-g(i-1))/(2*de); end  
end
% % plot(ksi, g, 'r', ksi, u_cubic); xlabel('y/\delta'); ylabel('u/uinf')
% % hold off
for i=1:nep
    fprintf('%9.3f %9.4f %9.4f %9.6f \n', eta(i), f(i), g(i), fpp(i))
end
