% A-2 Developing Regime 

clc; clear % Finding u, v, and p in the developing regime
%
b1=.001; % channel geometries (I), safer not to use the symbol b as the half height
nu=8.55e-7; rho=1000; mu=nu*rho; % fluid properties
un=.01; re=un*b1/nu; % flow conditions
pn= 0.1; % arbitrary reference pressure 
Lx=0.8*b1*re; dx=Lx/4; dy=b1/2; dys=dy*dy; % channel geometries (II) 
beta=mu*dx/dys; 
%u1=q1; u2=q2; u3=q3; u4=q4; u5=q5; u6=q6;
%v2=q7; v2=q8; v3=q9;  
%p1=q10; p2=q11; p3=q12; p4=q13; p5=q14; p6=q15; 
a(15,15)=0; b(15)=0;
for i=1:6; u(i)=un; end; 
for iter=1:20 % the solution has converged fortunately 
a(1,1)= beta; a(1,2)=- beta; a(1,10)=-1; a(1,12)=1;     % u1 eqn
a(2,1)=-beta; a(2,2)= 3*beta; a(2,11)=-1; a(2,13)=1;   % u2 eqn
a(3,3)= beta; a(3,4)=- beta; a(3,12)=-1; a(3,14)=1;     % u3 eqn
a(4,3)=-beta; a(4,4)= 3*beta; a(4,13)=-1; a(4,15)=1;   % u4 eqn
a(5,5)= beta; a(5,6)=-beta; a(5,14)=-1;                       % u5 eqn
a(6,5)=-beta; a(6,6)= 3*beta; a(6,15)=-1;                    % u6 eqn
a(7,7)=mu/dy; a(7,10)=-1; a(7,11)=1;                          % v1 eqn
a(8,8)=mu/dy; a(8,12)=-1; a(8,13)=1;                          % v2 eqn
a(9,9)=mu/dy; a(9,14)=-1; a(9,15)=1;                          % v3 eqn
a(10,1)=-dy; a(10,7)=-dx; b(10)=-un*dy; % p1 eqn (mass conservation) 
a(11,2)=-dy; a(11,7)= dx; b(11)=-un*dy; % p2 eqn (mass conservation) 
a(12,1)=dy; a(12,3)=-dy; a(12,8)=-dx;    % p3 eqn (mass conservation) 
a(13,2)=dy; a(13,4)=-dy; a(13,8)=dx;     % p4 eqn (mass conservation) 
a(14,3)=dy; a(14,5)=-dy; a(14,9)=-dx;    % p5 eqn (mass conservation)
a(15,4)=dy; a(15,6)=-dy; a(15,9)=dx;     % p6 eqn (mass conservation)
b(1)=rho*u(1)*(un-u(1));         b(2)=rho*u(2)*(un-u(2));
b(3)=rho*u(3)*(u(1)-u(3));       b(4)=rho*u(4)*(u(2)-u(4));
b(5)=rho*u(5)*(u(3)-u(5))-pn; b(6)=rho*u(6)*(u(4)-u(6))-pn; 
 
%
q = a\b'; u =q(1:6);  
u_and_v = q(1:9)'/un % velocity solution normalized on un
end
p = q(10:15)'

