% A-1 Laminar Flows in Circular Tubes

clc; clear 
gaC=5000; % an over-relaxation factor or under-relaxation factor  
R=0.03; 
new=8.55e-7; rho=1000; mu=new*rho; 
umn=0.03;
Re=umn*R/new % =1052.6 The flow should be laminar.  
C1=100; % guessed first 
nr=100; nrp=nr+1; dr=R/nr; drs=dr*dr; 
for j=1:nrp
    r(j)=(j-1)*dr; rr2(j)=dr/(2*r(j)+ 1e-10);
end
a(nrp,nrp)=0; b(nrp)=0; 
a(1,1)=1.5; a(1,2)=-2; a(1,3)=0.5;  
% 3-point approximation for du/dy=0 at the centerline 
a(nrp,nrp)=1; 
for iB=1:10
for j=2:nr
    a(j,j-1)=rr2(j)-1; a(j,j)=2; a(j,j+1)=-rr2(j)-1; b(j)=drs*C1;
end
u=a\b'; 
um=2*trapz(r,r.*u')/(R*R) % to find um 
C1=C1+ gaC*(umn - um) % 
end
plot(r,u)
C1 % = 266.6505
% analytical
u_center = u(1) % = 0.06  check!
dx=1; 
pressure_force = C1*mu*dx*pi*R*R % = 6.4462e-4 N
tauw=mu*(-.5*u(nr-1)+2*u(nr)-1.5*0)/dr; % 3-point approximation 
shear = tauw*dx*2*pi*R % = 6.4448e-4 N 
