% A-2 Fully Developed Turbulent Flows in Two-Parallel-Plate Channels

clc; clear 
ga=0.4; 
gaB=10000; % an over-relaxation factor or under-relaxation factor  
b1=0.02; 
new=8.55e-7; rho=1000; 
umn=0.2;
Re=umn*b1/new % = 4678.4
B2=9200; % guessed first 
ny=200; nyp=ny+1; dy=b1/ny; dys=dy*dy; dy2=dy*2; 
for j=1:nyp
    y(j)=(j-1)*dy; yplus(j)=y(j)*0.0119/new; 
    fac =1-exp(-yplus(j)/33); 
    Lv(j)=0.4*y(j)*fac; % van Driest mixing length 
    nus(j)=Lv(j)*Lv(j)/new; %initial guess
    u(j)=umn; % initial guess
end
a(nyp,nyp)=0; b(nyp)=0; 
a(1,1)=1; 
% 3-point approximation for du/dy=0 at the centerline 
a(nyp,ny-1)=.5; a(nyp,ny)=-2; a(nyp,nyp)=1.5; 
%
for iB=1:35
    for iter=1:30
    for j=2:ny
        dudy(j)=(u(j+1)-u(j-1))/dy2; 
        nus(j)=dudy(j)*Lv(j)*Lv(j)/new; 
    end
    nus(1)=0; nus(nyp)=nus(ny); 
    %
    for j=2:ny
        jm=j-1; jp=j+1; 
        dnusdy=(nus(jp)-nus(jm))/dy2; 
        E1=dudy(j)*dnusdy; E2=1+nus(j); B3=(B2+E1)/E2; 
    a(j,jm)=-1; a(j,j)=2; a(j,jp)=-1; b(j)=dys*B3;
    end
    q=a\b'; u=ga*q'+(1-ga)*u; % under-relaxation 
    end
um=trapz(y,u)/b1 % = 0.2 converged to umn  
B2=B2 + gaB*(umn - um);  
%plot(y,u); hold on
end
%hold off
% post processing 
tauw=new*rho*(u(2)-0*.5*u(3))/dy; 
utau=sqrt(tauw/rho) % = 0.0119
Cf =2*tauw/(rho*umn*umn); % = 0.00707  very good agreement
Cf_nagaosa = 0.05905*Re^(-.25); % = 0.00714 ..very good agreement
fprintf('%9.5f %9.5f \n', Cf, Cf_nagaosa) 
Z=1; dx=1; 
shear=tauw*Z*dx % = 0.1414 N .forces balanced 
pressure_force=B2*new*rho*dx*b1*Z % = 0.1408 Nforces balanced 

