% A-1Computing Stefan-Boltzmann Constant 

clc; clear % finding the value of sigma (Stefan-Boltzmann constant) 
               % and plot Eb vs. Lambda 
c1=3.742e+8; c2=1.439e+4; 
L=200; nx=40000; dx=L/nx; nxp=nx+1; % take Lambda between 0 and 2000
for iT=1:3
T=700+(iT-1)*150;   
for i=1:nxp
Lam(i)=1e-6+(i-1)*dx; % avoid division by zero. 
L5=Lam(i)^5; cLT=c2/(Lam(i)*T); ELb(i)=c1/(L5*exp(cLT)-L5); 
end
area=trapz(Lam, ELb);
sig=area/T^4; % = 5.667e-8 
plot(Lam(1:4000), ELb(1:4000)); hold on
text(3, max(ELb)+300, ['T=', num2str(T), 'K'])
end
xlabel('\lambda in \mu'); ylabel('E_\lambda_,_b')
hold off
