% A-2 Finding Emission Fractions 

clc; clear % finding Fractions of Band Emissions 
c1=3.742e+8; c2=1.439e+4; sig=5.67e-8; 
L=6; nx=6000; dx=L/nx; nxp=nx+1; % take Lambda between 0 and 6
T=2000; 
for i=1:nxp
Lam(i)=1e-6+(i-1)*dx; % avoid division by zero. 
L5=Lam(i)^5; cLT=c2/(Lam(i)*T); ELb(i)=c1/(L5*exp(cLT)-L5); 
end
for i=501:100:nxp
area=trapz(Lam(1:i), ELb(1:i));
F =area/(sig*T^4); LT=Lam(i)*T;
fprintf('%9.0f %9.4f \n', LT, F)
end
