% A-1 Two Convective Boundary Conditions 

clc; clear
% solve Eq. (2) on p. 37, subject to 
% two convective airflow bondary conditions
Tinf1=100; Tinf2=0; % all in Celcius
h1=100; h2=150; 
L=0.1; k=237; qgen=1e6; % aluminum
nx=20; dx=L/nx; dxs=dx*dx; nxp=nx+1; % grid system 
x=linspace(0,L,nxp); 
% important parameters 
bi1=h1*dx/k; bi2=h2*dx/k; qgs=qgen*dxs/k;
% set a and b to zero for convenience. 
a(nxp,nxp)=0; b(nxp)=0; 
% boundary condition
a(1,1)=1+bi1; a(1,2)=-1; b(1)=bi1*Tinf1; 
a(nxp,nx)=-1; a(nxp,nxp)=1+bi2; b(nxp)=bi2*Tinf2; 
for i=2:nx
    a(i,i-1)=-1; a(i,i)=2; a(i,i+1)=-1; b(i)=qgs; 
end
T=a\b'; 
plot(x,T); xlabel('x'); ylabel('T'); 
% check the global energy balance
qf1=h1*(Tinf1-T(1)); qf2=h2*(T(nxp)-Tinf2);
qgen_total = qgen*(L-dx); 
% Be careful that we did not consider two half grid intervals.
qf1+qgen_total % 6.2617e4
qf2 % 6.2617e4
