% A-2 Optimization of Lb

clc; clear % optimize the value of Lb to achieve the goal of minimal interface temperature 
La = 0.1;
ka = 10; kb = 7.3; Qg = 0.2e5;
TL = 0; TR = 100; 
Lb1=0.1; Lb2=0.5; dLb = (Lb2-Lb1)/20; % vary Lb from 0.1m to 0.5m
for iLb = 1:21
Lb = Lb1+(iLb-1)*dLb; 
Lplot(iLb)=Lb; % stored for plotting only 
dx = Lb/4; c1 = (kb/ka)*(La/dx); 
c2 = Qg*dx*dx/kb; 
a(4,4) = 0; b(4) = 0; 
a(1,1) = 1+c1; a(1,2) = -c1; b(1) = TL;
a(2,1) = 1; a(2,2) = -2; a(2,3) = 1; b(2) = -c2;
a(3,2) = 1; a(3,3) = -2; a(3,4) = 1; b(3) = -c2; 
a(4,3) = 1; a(4,4) = -2; b(4) = -c2-TR; 
T = a\b'; Tplot(iLb) = T(1);
end
plot(Lplot, Tplot); 
xlabel('thickness of Lb'); ylabel('interface temperature T1')
hold off
% T1m = min(Tplot) % = 37.125C 
% Index = find(Tplot <=T1m) % at iLb = 8 
% Lb = Lb1 + (Index-1)*dLb % Lb = 0.24 
