% A-1. Explanation of the Seemingly Puzzling Phenomenon
clc; clear
for ik=1:11
k=300+(ik-1)*10;
D=.004; Ac=D*D*pi/4; p=pi*D;
h=150; T_inf=20; Tb=120;
Lx=0.5; nx=150; dx=Lx/nx; dxs=dx*dx; nxp=nx+1;
c1=h*p*dxs/(k*Ac); 
a=zeros(nxp); b=zeros(1,nxp); % establish the base for the sparse matrix.
x=linspace(0,Lx, nxp);
a(1,1)=1; b(1)=Tb;
for i=2:nx
a(i,i-1)=1; a(i,i)=-(2+c1); a(i,i+1)=1; b(i)=-c1*T_inf;
end
a(nxp,nx)= -1; a(nxp,nxp)=1; % The tip of the fin is insulated.
T=a\b';
%plot(x,T); axis([0 Lx 15 120]); hold off
dTdxn = (T(1)-T(2))/dx; 
qf2 = k*Ac*dTdxn;
fprintf('%7.0f %9.4f %9.4f \n', k, dTdxn, qf2)
end
