% A-2 Cubic-Polynomial Temperature Profile 

clc; clear
k=400; D=.004; Ac=D*D*pi/4; h=20; 
% At h=2, quadratic model is still good. But not at h=20
Lx=0.4; nx=200; dx=Lx/nx; dxs=dx*dx; nxp=nx+1;
p=pi*D; c1=h*p*dxs/(k*Ac); 
Tb=120; Tinf=20; 
a=zeros(nxp); b=zeros(1,nxp); % establish the base for the sparse matrix.
x=linspace(0,Lx, nxp);
a(1,1)=1; b(1)=Tb;
for i=2:nx
a(i,i-1)=1; a(i,i)=-(2+c1); a(i,i+1)=1; b(i)=-c1*Tinf;
end
a(nxp,nx)=-1; a(nxp,nxp)=1; % The tip of the fin is insulated.
T=a\b';
% check global energy balance
sum=0;
for i=2:nx
sum=sum+h*p*dx*(T(i)-Tinf);
end
qbase = k*Ac*(T(1)-T(2))/dx %
qconv = sum % 
%
be=h*p*Lx*Lx/(k*Ac); dT=Tb-Tinf; e1=0.5; 
% >>>>> quadratic polynomial 
a=[1  2; 1+be/2  be/3]; b=[0  -be*dT];
d=a\b'; 
Tm = Tb + d(1)/2 + d(2)/3 
% >>>>> cubic polynomial 
aa=[1  2  3; 1+be/2  be/3  be/4; 
   e1*e1*be/2  e1^3*be/3-2*e1  e1^4*be/4-3*e1^2];
bb=[0  -be*dT  -e1*be*dT]; 
d=aa\bb';
Tm = Tb + d(1)/2 + d(2)/3 +d(3)/4
% >>>>>
for i=1:nxp
    kxi(i)=x(i)/Lx; 
  %  Tpoly(i)=Tb+kxi(i)*d(1)+kxi(i)^2*d(2);
    Tpoly(i)=Tb+kxi(i)*d(1)+kxi(i)^2*d(2)+kxi(i)^3*d(3);
end
plot(x/Lx,T, kxi, Tpoly, 'r--'); axis([0 1 15 120]); 
xlabel('x'); ylabel('T'); hold off
text(0.2, 100, 'red: cubic, h=20 W/m^2-K')
qbase2=-k*Ac*d(1)/Lx 
qconv2=h*p*Lx*(Tm-Tinf)
