% A-3 Constraint of Fixed Fin Mass (or Volume)

clc; clear
Tb=120; T_inf = 20; h = 50;
k=250; D=.003; Ac=D*D*pi/4; Lx =0.12; Vt = Ac*Lx;
dLx = 0.005;% increment of fin-length change 
for iL = 1:31
    Lx = 0.02 + (iL-1)*dLx; Lxplot(iL) = Lx; 
Ac=Vt/Lx; D = sqrt(Ac*4/pi); p=pi*D; 
nx=20; dx=Lx/nx; dxs=dx*dx; nxp=nx+1; 
c1=h*p*dxs/(k*Ac); 
%
a=zeros(nxp); b=zeros(1,nxp); % establish the base for the sparse matrix.
x=linspace(0,Lx, nxp);
a(1,1)=1; b(1)=Tb;
for i=2:nx
a(i,i-1)=1; a(i,i)=-(2+c1); a(i,i+1)=1; b(i)=-c1*T_inf;
end
a(nxp,nx)=-1; a(nxp,nxp)=1; 
% The tip of the fin is insulated.
T=a\b';
%plot(x,T); axis([0 Lx 15 120]); hold off 
dTdxn = (T(1)-T(2))/dx;  
qf = k*Ac*dTdxn; qfplot(iL)= qf; 
end
plot(Lxplot, qfplot) 
xlabel('Lx (not x)'); ylabel('cooling rate') 
