% A-4 Fin Bundles and Optimization 

clc; clear
% h = c1 - c2*n^2, where c1 = 8.0188 and c2 = 0.0188
% T_inf = 20 + (n-1)*2.4,
k=30; D=.003; Ac=D*D*pi/4; Lx = .12; 
nx=20; dx=Lx/nx; dxs=dx*dx; nxp=nx+1; p=pi*D;
Tb=120;
c1 = 8.0188; c2 = 0.0188; 
for n=1:20
nv(n)= n; 
T_inf = 20 + (n-1)*2.4; h = c1-c2*n^2;     
e1=h*p*dxs/(k*Ac); 
a=zeros(nxp); b=zeros(1,nxp); % establish the base for the sparse matrix.
x=linspace(0,Lx, nxp);
a(1,1)=1; b(1)=Tb;
for i=2:nx
a(i,i-1)=1; a(i,i)=-(2+e1); a(i,i+1)=1; b(i)=-e1*T_inf;
end
a(nxp,nx)=-1; a(nxp,nxp)=1; % insulated at the tip
T=a\b';
%plot(x,T); axis([0 Lx 15 120]); hold off
dTdxn = (T(1)-T(2))/dx;  
qf = k*Ac*dTdxn; qfplot(n)= n*qf; 
end
plot(nv, qfplot); grid on  % n ~ 12 
xlabel('number of fins'); ylabel('total cooling rate')

