% A-2 A standard 2-D steady state code

clc; clear
k=5; qgen=1e5; % properties of the solid 
Lx=0.2; nx=10; dx=Lx/nx; dxs=dx*dx; nxp=nx+1; % grid system
Ly=0.3; ny=10; dy=Ly/ny; dys=dy*dy; nyp=ny+1;  
r1=(dx/dy)^2; r22=2+2*r1; qs=qgen*dxs/k; % convenient quantities
for i=1:nxp; for j=1:nyp; T(i,j)=0; end; end; % initial guess
for j=2:ny; T(1,j)=100; T(nxp,j)=0; end % boundary condition
for i=1:nxp; T(i,1)=100-(i-1)*10; end; T(:,nyp)=T(:,1);
a=zeros(nxp); b=zeros(1,nxp);
a(1,1)=1; b(1)=T(1,2); % boundary equ.
a(nxp,nxp)=1; b(nxp)=T(nxp,2); % boundary equ. 
%>>>>>>>>>> compute interior nodal T's 
 for iter=1:50
 for j=2:ny
 for i=2:nx
     a(i,i-1)=-1; a(i,i)=2+2*r1; a(i,i+1)=-1; 
     b(i)=r1*(T(i,j-1)+T(i,j+1))+qs; 
 end
     qq=a\b'; T(:,j)=qq; % update T 
 end
 end 
%>>>>>>>>>> 
    for i=1:nxp; for j=1:nyp 
    x(i,j)=(i-1)*dx; y(i,j)=(j-1)*dy; 
    end; end
xr=flipud(x'); yr=flipud(y'); Tr=flipud(T'); 
Tr
mesh(xr,yr,Tr)
% check the global energy balance
qgenT=qgen*(nx-1)*(ny-1)*dx*dy; 
qW=0; qE=0; qS=0; qN=0; 
for j=2:ny; 
qW = qW+ k*dy*(T(1,j)-T(2,j))/dx; 
qE = qE+ k*dy*(T(nx,j)-T(nxp,j))/dx; 
end
for i=2:nx
    qS = qS + k*dx*(T(i,1)-T(i,2))/dy;
    qN = qN + k*dx*(T(i,ny)-T(i,nyp))/dy;
end
qinT = qW + qS + qgenT % = 3.105e3 W  
qoutT = qE + qN % = 3.105e3 W 
