% A-3 Optimization Problem in the Cylindrical Coordinates
clc; clear % cylinder
k=0.05; h=7; Tinf=-10; R1=0.001; Lx=1.76;
for iR=1:40
    R2= R1 + (iR-1)*0.001;
    Rplot(iR)=R2; % for plotting only
    dR=R2-R1; nr=40; dr=dR/nr; nrp=nr+1;
    bi=h*dr/k;
    T(1)=37; T(nrp)=-10;
    a=zeros(nrp); b=zeros(1,nrp);
    a(1,1)=1; b(1)=T(1); %a(nrp,nrp)=1; b(nrp)=T(nrp);
    a(nrp,nr)=-1; a(nrp,nrp)=1+bi; b(nrp)=bi*Tinf;
    for j=1:nrp
        r(j)=R1+(j-1)*dr;
    end
    for j=2:nr
        a(j,j-1)=r(j)-0.5*dr; a(j,j)=-2*r(j); a(j,j+1)=r(j)+0.5*dr;
    end
    T=a\b';
    %plot(r, T);
    qout(iR)=(R2-0.5*dr)*(T(nr)-T(nrp))/dr;
end
plot(Rplot, qout); grid on
xlabel('thickness of insulation'); ylabel('heat loss in W')
% check the global energy balance
qin = k*(2*pi*Lx)*(R1+0.5*dr)*(T(1)-T(2))/dr % = 6.7767 W
qout= h*(2*pi*Lx)*(R2-0.5*dr)*(T(nrp)-Tinf)  % = 6.7767 W

