% A-2 Comparisons of Three Cases: 

%>>>> quadratic approximation
clc; clear
h=200; Tinf = 100; Lx=0.2; rho=1000; cv=2300; k=20; dt=20;
Tmq(1)=0; time(1)=0; Tmp=Tmq(1); 
c1=h*dt/(rho*cv*Lx); Bi=h*Lx/k; 
for itm = 2:601
    time(itm)=(itm-1)*dt;
    a=[-Bi 0 1 0; 0 0 1 2; 1 -1 1/2 1/3; c1 1 0 0];
    b=[-Bi*Tinf 0 0 c1*Tinf+Tmp]; 
    q=a\b'; Tmp=q(2); Tmq(itm)=q(2); 
end
%
%>>>> 1-D transient conduction 
clear a b 
nx=40; nxp=nx+1; dx=Lx/nx; dxs=dx*dx; aLf=k/(rho*cv); 
r=aLf*dt/dxs; Tma(1)=0; bi=h*dx/k; 
a(nxp,nxp)=0; b(nxp)=0; Tp(nxp)=0; 
for itm =2:601
sum =0; 
a(1,1)=1+bi; a(1,2)=-1; b(1)= bi*Tinf; 
for i=2:nx
    a(i,i-1)=-r; a(i,i)=2*r+1; a(i,i+1)=-r; b(i)=Tp(i); 
end
a(nxp,nx)=-1; a(nxp, nxp)=1; 
T=a\b'; Tp=T; 
for i=1:nxp
    sum = sum +T(i);
end
Tma(itm)=sum/nxp;
end
%>>>> lumped-capacitance model 
Tmz(1)= 0; Tmp=0;  
for itm=2:601
    Tmz(itm)= (Tmp + c1*Tinf)/(1+c1); Tmp=Tmz(itm);
end
%>>>> Final Plot
plot(time, Tmq,'k--', time, Tma,'r', time, Tmz,'k-.') 
xlabel('time in sec'); ylabel('T-mean');
text(4000,60,'solid:1-D'); text(4000, 53,'dash line: quadratic');
text(4000,46,'dash-dot line: lumped-capacitance')
