% A-1 Semi-Infinite Solids

clc; clear
%>>>>>>>>>> input data, semi-infinite solid
k=0.5; rho=2023; cv=1825; aLf=k/(rho*cv);
L=2; nx=60; nxp=nx+1; dx=L/nx; dxs=dx*dx; 
Lt=30*24*3600; nt=20; dt=Lt/nt; 
r=aLf*dt/dxs;
T_coldfront=-10; T_initial=20; 
x=linspace(0,L,nxp); 
%>>>>>>>>>> initial condition or initializing
a=zeros(nxp,nxp); b=zeros(1,nxp); 
Tp=T_initial*ones(1,nxp); time(1)=0; 
%>>>>>>>>>> prescribe the B. C.s 
a(1,1)=1; b(1)=T_coldfront; 
a(nxp,nx)=-1; a(nxp,nxp)=1; % assume dT/dx=0 at x=L 
%>>>>>>>>>> interior-T gov. eq. 
for i = 2:nx
a(i,i-1)= -r; a(i,i)= 2*r + 1; a(i,i+1)= -r; 
end 
for it=2:nt+1
time(it)=(it-1)*dt; 
for i=2:nx; b(i)= Tp(i);end 
T=a\b'; Tp=T;  
T2(it)=T(2);
plot(x,T); hold on; xlabel('x'); ylabel('T') 
end 
axis([0,2,T_coldfront,T_initial]);
text(0.3, -3, 'As time increases, the T curve shifts down')
hold off
% check the energy balance globally and totally
%
sum1=0; sum2=0; 
for it=2:nt+1
sum1 =sum1+(k*(T(1)-T2(it))/dx)*dt;
end
for i=2:nx
    sum2=sum2 + dx*rho*cv*(T(i)-(T_initial));
end
q_total = sum1 % = -7.1754e7 J/m^2
dU=sum2 % =% -7.1754e7 J/m^2 
