% A-2 Transient 1-D Fins

clc; clear
%>>>>>>>>>> input data
h=10; Tinf=25; Tb=100; 
k=398; rho=8933; cv=385; aLf=k/(rho*cv); 
D=0.006; Ac=D*D*pi/4; p=pi*D; 
L=0.6; nx=20; dx=L/nx; dxs=dx*dx; nxp=nx+1; 
Lt=1200; nt=40; dt=Lt/nt; 
r=aLf*dt/dxs; c2=(h*p/k)*(aLf*dt/Ac);
x=linspace(0,L,nxp); 
%>>>>>>>>>> initialize a and b, and prescribe the B. C.s 
a(nxp,nxp)=0; b(nxp)=0; 
a(1,1)=1; b(1)=Tb;
a(nxp,nx)=-1; a(nxp,nxp)=1;
%
%>>>>>>>>>> initial condition
for i=1:nxp
Tp(i)=Tinf; 
end 
time(1)=0; 
%>>>>>>>>>> interior-T gov. eq. 
for i = 2:nx
a(i,i-1)= -r; a(i,i)= 2*r+1+c2; a(i,i+1)= -r; 
end 
qconv(nt+1)=0; 
for it=2:nt+1
time(it)=(it-1)*dt; 
for i=2:nx; b(i)= Tp(i)+c2*Tinf; end 
T=a\b'; Tp=T; 
T2(it)=T(2); % = store up values of T2 
plot(x,T); hold on; xlabel('x'); ylabel('T') 
for i=2:nx
qconv(it) = qconv(it) + dx*p*h*(T(i)-Tinf);
end
end 
hold off
text(0.2, 90, 'As time elapses, the curve shifts up.') 
axis([0,L,20,Tb]); 
%>>>>>>>>>> check the total energy balance 
sum1=0; sum2=0;  
for it=2:nt+1
qbase=k*Ac*(Tb-T2(it))/dx; 
sum1 =sum1+(qbase-qconv(it))*dt;
end
for i=2:nx
    sum2=sum2 + dx*Ac*rho*cv*(T(i)-Tinf);
end
q_total = sum1 % = 1.6038e3 J
dU=sum2 % = 1.6038e3 J 

