% A-3 Example 4-1 Revisited

clc; clear
ka=75; La=.05; Qa=1.5e6;
kb=150; Lb=.02; 
h=1000; T_inf=30;
nx=300; nxp=nx+1; nxq=nx+2; dx=La/nx; dxs=dx*dx; 
c1=Qa*dxs/ka; c2=(kb/ka)*(dx/Lb); Bi=h*Lb/kb;
a=zeros(nxq); b=zeros(1,nxq);
x1=linspace(0,La,nxp); x=[x1, La+Lb]; 
a(1,1)=1; a(1,2)=-1;
for i=2:nx
a(i,i-1)=1; a(i,i)=-2; a(i,i+1)=1; b(i)=-c1; 
end
a(nxp,nx)=1; a(nxp,nxp)=-(1+c2); a(nxp,nxq)=c2;
a(nxq,nxp)=1; a(nxq,nxq)=-(1+Bi); b(nxq)=-Bi*T_inf; 
T=a\b';
%>>>>> suddenly, material B is removed. 
rho=8000; cv=450; dtm=300; 
Qgs=Qa*dtm/(rho*cv); aLf=ka/(rho*cv); r=aLf*dtm/dxs; 
bi=h*dx/ka; 
Tp=T(1:nxp);
plot(x1, Tp); hold on % initial condition
for itm=2:11
aa(1,1)=1; aa(1,2)=-1; 
for i=2:nx
aa(i,i-1)=-r; aa(i,i)=1+2*r; aa(i,i+1)=-r; bb(i)=Tp(i)+Qgs; 
end
aa(nxp,nx)=1; aa(nxp,nxp)=-(1+bi); bb(nxp)=-bi*T_inf; 
Ta=aa\bb'; Tp=Ta; 
plot(x1,Ta); hold on
end; hold off
