% A-1 A Standard Transient 2-D Code for Readers to Modify

clc; clear % a standard code for readers to modify
Lx=1; Ly=2;
nx=10; ny=10; nxp=nx+1; nyp=ny+1; dx=Lx/nx; dy=Ly/ny;
dxs=dx*dx; dys=dy*dy; 
rx=.3; ry=.2; 
for i=1:nxp
for j=1:nyp
x(i,j)=(i-1)*dx; y(i,j)=(j-1)*dy; 
Tp(i,j)=0; T(i,j)=Tp(i,j);
a(i,j)=0; b(i)=0; 
end
end
% specify BC
T(1,ny/2+1)=100; 
for it=2:2
for iter=1:10
for j=2:ny
    a(1,1)=1; b(1)=T(1,j); 
    a(nxp,nxp)=1; b(nxp)=T(nxp,j); 
for i=2:nx
    a(i,i-1)=-rx; a(i,i)=1+2*rx+2*ry; a(i,i+1)=-ry; 
b(i)=Tp(i,j)+ry*(T(i,j-1)+T(i,j+1)); % treating TS and TN as knowns
end
q=a\b'; T(:,j)=q; % update for iteration 
end
end
Tp=T; % update for time marching 
end
T_real=flipud(T')
x_real=flipud(x'); y_real=flipud(y');
mesh(x,y,T)
