% A-3. Investigation of Transient 2-D Heat Conduction for the Concrete Column 

clc; clear % steel melting, 2-D, 9/11
k=0.8; rho=2100; cv=1100; aLf=k/(rho*cv);
Lx=0.6; Ly=0.6;
nx=6; ny=6; nxp=nx+1; nyp=ny+1; dx=Lx/nx; dy=Ly/ny;
dxs=dx*dx; dys=dy*dy;
Lt=3600; nt=20; dt=Lt/nt;  
rx=aLf*dt/dxs; ry=rx;  
for i=1:nxp
for j=1:nyp
x(i,j)=(i-1)*dx; y(i,j)=(j-1)*dy; 
Tp(i,j)=20; T(i,j)=Tp(i,j);
a(i,j)=0; b(i)=0; 
end
end
% specify BC
for j=2:ny; T(1,j)=1000; T(nxp,j)=1000; end
for i=2:nx; T(i,1)=1000; T(i,nyp)=1000; end
for it=2:nt+1
for iter=1:10
for j=2:ny
    a(1,1)=1; b(1)=T(1,j);  a(nxp,nxp)=1; b(nxp)=T(nxp,j); 
for i=2:nx
    a(i,i-1)=-rx; a(i,i)=1+2*rx+2*ry; a(i,i+1)=-ry; 
b(i)=Tp(i,j)+ry*(T(i,j-1)+T(i,j+1)); % treating TS and TN as knowns
end
q=a\b'; T(:,j)=q; % update for iteration 
end
end
Tp=T; % update for time marching 
end
T_real=flipud(T')
x_real=flipud(x'); y_real=flipud(y');
mesh(x,y,T)
