clc; clear
Lx=0.1; k=1; h1=100; h2=200; 
Tinf1=0; Tinf2=100; dT=Tinf2-Tinf1; 
for igen=1:2 % generate two cases: qgen=0 and qgen=1e5. 
qgen=(igen-1)*1e5; 
Qs =qgen*Lx*Lx/(k*dT); % qgen non-dimensionalized
Bi1=h1*Lx/k; Bi2=h2*Lx/k; 
% The most important equation is the global 
%  conservation of energy 
a=[1  -1  1  1; Bi1  0  -1  0; 0  Bi2  1  2; Bi1  Bi2  0  0]; 
b=[0  0  Bi2  Qs+Bi2]; 
% ?1  ?2 + d1 + d2 = 0 .1st row
% Bi1*?1  d1 = 0 .. 2nd row  
% Bi2*?2 +d1 +2*d2 = Bi2 . ..3rd row
% Bi1* ?1 + Bi2* ?2= Qs + Bi2 .. 4th row 
q=a\b'; th1=q(1); th2=q(2); d1=q(3); d2=q(4); 
nx=20; nxp=nx+1; dx=Lx/nx; 
for i=1:nxp
    x(i)=(i-1)*dx; ksi=x(i)/Lx; 
    th(i)=th1+d1*ksi+d2*ksi*ksi; % find ? first 
    T(i)=Tinf1+th(i)*dT; % recover T from  ?
end
plot(x, T); xlabel('x'); ylabel('T'); hold on
end; text(0.05, 45, 'Qgen = 0'); text(0.04, 195, 'Qgen = 10^5'); 
