 clc; clear 
% Most quantities here are dimensional.
Lx=.3; 
ny=1000; Ly=Lx/5; dy=Ly/ny; dys=dy*dy; nyp=ny+1; 
rhoa=1.18; cpa=1005; ka=.026; aLfa=ka/(rhoa*cpa); Tinf=45;
for iPr=1:3 % investigate cases for three Pr values
new=1.6e-5; Pr=iPr*new/aLfa;
HCL=(1.026+(Pr/0.7298)^0.6)*Lx;%The heat convection length was found after many numerical 
                                                     % experiments, and is purely empirical. 
for iu=1:11 %  Vary u_inf, thus vary Re_L. 
u(iu)= 1.5 +(iu-1)*2;
Re(iu)=u(iu)*Lx/new; Pe=Pr*Re(iu); 
c1=dys*Pe/(HCL*Lx); % a convenient term
for j=1:nyp; y(j)=(j-1)*dy; end
T(1)=15; T(nyp)=Tinf;
a=zeros(nyp, nyp); 
% It is convenient to set all the elements in 
% the coefficient matrix to zeros first. 
%
a(1,1)=1; b(1)=T(1); a(nyp,nyp)=1; b(nyp)=T(nyp);
for j=2:ny
a(j,j-1)= -1; a(j,j)=(2+c1); a(j,j+1)= -1; 
b(j)= c1*Tinf; 
end
T=a\b';
%
Qs=ka*(1.5*T(1)-2*T(2)+.5*T(3))/dy; 
% We can also use the simple 2-point approximation, which is Qs = ka*(T(1)  T(2))/dy.
DT=T(1)-Tinf; % T(1)= Ts; Tinf = T(nyp) = T(1001) 
h_cur(iu)=Qs/DT; % current computations
h_Lit(iu)=.664*Re(iu)^0.5*Pr^(1/3)*ka/Lx; % literature values
end 
%
plot(Re,h_cur,Re,h_Lit,'r'); hold on % The two curves are almost indistinguishable.
xlabel('Re_L'); ylabel('heat transfer coefficient, h')
text(1.1e5, 15, 'Computed h in blue')
text(1.1e5, 13, 'Literature h in red') 
text(3.47e5, h_Lit(9), ['Pr=',num2str(Pr)])
end 
hold off 
