clc; clear
% heating of the water flow and Ts=constant
b=0.01; Lx=5; Z=1; % geometry of the channel 
k=0.61; rho=1000; cp=4180; aLf=k/(rho*cp);nu=9.5e-7;%fluid properties
um=0.04; Tm_in=20; Ts=103.14; % flow conditions 
pr=nu/aLf; re=um*b/nu %=421.05, physical parameters
nu=9.5e-7; pr=nu/aLf %=6.51
pe=pr*re; Nu=1.8968;
H=Nu; h=Nu*k/b % = 115.7 
nx=100; nxp=nx+1; dx=Lx/nx; 
% start calculation of the problem
for i=1:nxp; 
    x(i)=(i-1)*dx; 
    Tm(i)=Ts+(Tm_in-Ts)*exp(-H*x(i)/(pe*b));
end
sum=0; 
for i=2:nxp 
    Tavg=.5*(Tm(i-1)+Tm(i)); qs=h*(Tavg-Ts)*dx*Z;
    sum = sum + qs;
end
Tm_ex=Tm(nxp)% =44.3178C
Qs = sum % = -40.659 kW 
mflow = rho*b*um; 
Qs_mass = mflow*cp*(Tm_ex-Tm_in) % = -40.659 kW
