% water dripping from the faucet in severely cold winter
clc; clear
% water properties
k=0.61; rho=1000; cp=4180; aLf=k/(rho*cp); 
% geometries of the pipe 
d=.017; p=pi*d; Ac=pi*d*d/4; h=2; 
Lx=6; nx=40; dx=Lx/nx; nxp=nx+1; 
x=linspace(0, Lx, nxp); 
% parameters in the governing equation 
bi=h*dx/k; ratio=p*dx/Ac; c1=bi*ratio; 
for iu=1:2
% when iu=1, we examine the case of turning off the faucet completely. 
um=(iu-1)*7e-4; pe=um*dx/aLf;  
a(nxp,nxp)=0; b(nxp)=0; 
T(1)=15; Tsurr=-10; 
a(1,1)=1; b(1)=T(1);
for i=2:nx
a(i,i-1)=0.5*pe+1; a(i,i)=-2-c1; 
a(i,i+1)=1-0.5*pe; b(i)=-c1*Tsurr; 
end
a(nxp,nx)=-1; a(nxp,nxp)=1;  
T=a\b'; 
plot(x,T); hold on; grid on;
xlabel('x'); ylabel('T-water')
end
text(3.2,5.7,'faucet dripping'); 
text(0.2, -7.5, 'faucet closed') 
hold off
