clc; clear % laminar flows in a plate channel 
gaB=5000; % an over-relaxation factor or under-relaxation factor  
b1=0.02; 
new=8.55e-7; rho=1000; 
umn=0.02;
Re=umn*b1/new % = 467.84 The flow should be laminar.  
B2=3; % guessed first 
ny=100; nyp=ny+1; dy=b1/ny; dys=dy*dy; 
for j=1:nyp
    y(j)=(j-1)*dy;
end
a(nyp,nyp)=0; b(nyp)=0; 
a(1,1)=1; 
% 3-point approximation for du/dy=0 at the centerline 
a(nyp,ny-1)=.5; a(nyp,ny)=-2; a(nyp,nyp)=1.5; 
for iB=1:10
for j=2:ny
    a(j,j-1)=-1; a(j,j)=2; a(j,j+1)=-1; b(j)=dys*B2;
end
u=a\b'; 
um=trapz(y,u)/b1 % to find um 
B2=B2+ gaB*(umn - um); % 
end
plot(y,u)
B2 % = 150.0013
% analytical
B2_analytical = 3*umn/(b1*b1) % = 150 
u_center = u(nyp) % = 0.03  check!
