clc; clear 
Z=1; L=10; b1=0.01; dy=b1/2; % channel geometries. 
nx=40; nxp=nx+1; dx=L/nx; dys=dy*dy; 
e1=0.001; kp=30; 
cp=4180; k=0.61; rho=1000; aLf=k/(rho*cp); % fluid properties 
Tm_inh = 90; Tm_inc=10; uc=.003; uh=.006; % flow conditions 
c1=(kp*dy)/(k*e1); pec=uc*dys/(dx*aLf); peh=uh*dys/(dx*aLf);
%
for j=2:4; Tw(j)=Tm_inc; end
for j=7:9; Tw(j)=Tm_inh; end
for j=5:6; Tw(j)=0.5*(Tm_inc+Tm_inh); end
Tw(1)=Tw(2); Tw(10)=Tw(9); 
% for plotting only
Tmc(1)= Tm_inc; Tmh(1)=Tm_inh; x(1)=0; 
%
a(10,10)=0; b(10)=0;
for i=2:nxp
x(i)=(i-1)*dx; 
a(1,1)=-1; a(1,2)=1; 
for j=2:4
    a(j,j-1)=1; a(j,j)=-(2+pec); a(j,j+1)=1; 
    b(j)=-pec*Tw(j); 
end
a(5,4)=1; a(5,5)=-(1+c1); a(5,6)=c1;
a(6,5)=c1; a(6,6)=-(1+c1); a(6,7)=1; 
for j=7:9
    a(j,j-1)=1; a(j,j)=-(2+peh); a(j,j+1)=1; b(j)=-peh*Tw(j); 
end
a(10,9)=1; a(10,10)=-1; 
q=a\b'; Tw=q; q'  % update the temperatures and march along x
%
Tmc(i)=(q(2)+q(3)+q(4))/3; Tmh(i)=(q(7)+q(8)+q(9))/3; 
q_HX(i)=dx*Z*kp*(q(5)-q(6))/e1; 
end 
plot(x,Tmc, x, Tmh,'r--'); xlabel('streamwise distance, x'); 
ylabel('Tm'); text(4, 46, 'cold flow'); text(4, 73, 'hot flow'); 
hold off 
%
dT1=Tm_inh - Tm_inc; dT2=Tmh(nxp)-Tmc(nxp); 
LMTD= (dT1-dT2)/log(dT1/dT2);
Nu=1.98; %(average of 2.0586 for constant qs and 1.8968 for constant Ts)
hc=Nu*k/b1; hh=hc
U= 1/(1/hc + e1/kp + 1/hh);
qs_literature =-U*Z*L*LMTD % = -1.5883e4 W
%
sum=0;
for i=2:nxp
    sum=sum+q_HX(i);
end
qs_HX = sum % = -9.4587e3 W
% check the global energy conservation
Gain_cold = rho*3*dy*Z*uc*cp*(Tmc(nxp)-Tmc(1)) % =  -9.4587e3 W
Loss_hot  = rho*3*dy*Z*uh*cp*(Tmh(nxp)-Tmh(1)) % = -9.4587e3 W
