clc; clear
dt=20; h=4; A=7e-3; m=0.2; c=4180; 
sig=5.67e-8;
Tinf=298; ntm=300; tm(1)=0;
Tp=348; eps=.9; T(1)=Tp; % black coffee
for itm=2:ntm
tm(itm)=(itm-1)*dt;
if(tm(itm) ==1800); Tp=Tp-6; eps=0.1; end; 
Conv=(A*h/(m*c))*(Tinf-Tp);
Rad=(A*eps*sig/(m*c))*(Tp^4-Tinf^4);
% using the simple explicit method
S1=Conv-Rad; T(itm)=dt*S1+Tp; Tp=T(itm); 
end
plot(tm/60, T); hold on
xlabel('time in minutes'); ylabel('T.coffee'); 
%
Tp=342; eps=.1; T(1)=Tp; % coffee with cream, Tp is 6C lower than the black coffee case
for itm=2:ntm
Conv=(A*h/(m*c))*(Tinf-Tp);
Rad=(A*eps*sig/(m*c))*(Tp^4-Tinf^4);
S1=Conv-Rad; T(itm)=dt*S1+Tp; Tp=T(itm);
end
plot(tm/60, T, 'r--')
text(51, 331, 'black coffee'); text(58, 337, 'coffee with cream')
hold off
% Let us sketch T_black vs. time and T_cream vs. time qualitatively
