%% Explicit method 
clc; clear
m=0.3; cv=3000; h=500; A=0.02; e1=0.97; 
sig=5.67; 
% remember to divide T by 100 to absorb e-8. 
Tinf=600; Tp=200; 
% for convenience, temperature is in K. 
Tcloud=200; 
time(1)=0; T(1)=Tp; 
Su(1)=0; % entropy of the universe 
Lt=1000; nt=100; ntp=nt+1; 
dt=Lt/nt; c1=h*A*dt/(m*cv); c2=e1*sig*A*dt/(m*cv); 
for it=2:ntp 
itm=it-1; 
time(it)=itm*dt; 
T(it)= Tp+c1*(Tinf-Tp)-c2*(Tp/100)^4; 
Tavg=.5*(Tp+T(it)); 
Qconv=h*A*(Tinf-Tp)*dt; Qrad=e1*sig*A*dt*(Tp/100)^4; 
Ss=(Qconv-Qrad)/Tavg; 
SR=-Qconv/Tinf; 
Scloud = Qrad/Tcloud; % the second reservoir 
Su(it)=Su(itm)+Ss+SR+Scloud;  
Tp=T(it); 
end 
figure (1); plot(time/60, T); xlabel('t'); ylabel('T')
figure (2); plot(time/60, Su); xlabel('t'); ylabel('Suniv') 
% global total energy balance
sum = 0;
for it=2:ntp
itm=it-1;
sum = sum + h*A*dt*(Tinf -T(itm))-e1*sig*A*dt*(T(itm)/100)^4;
end
Q_in= sum % 
dU= m*cv*(T(ntp)-T(1)) % 
T(ntp)% = 586.9K (take Lt=4000 sec) 
