clc; clear
h=10; rho=2300; cv=800; k=1.4; aLf=k/(rho*cv); 
sig=5.67e-8; e1=0.9; 
L=0.02; dx=L/2; dxs=dx*dx; dt=100;
r=aLf*dt/dxs; 
d1=2*h*dt/(rho*cv*dx); d2=2*e1*sig*dt/(rho*cv*dx); 
% initially, both the air and the windshield are at 278K. 
Tinf=278; T=Tinf*ones(1,3); Tp=T; Tplot(1)=Tinf; 
time(1)=0; Qin=0; 
for itime=2:301
    time(itime)=(itime-1)*dt;
for iter=1:7
    a=[2*r+1   -2*r     0; 
       -r     2*r+1    -r;
       0       -2*r     2*r+d1+1]; 
   b=[Tp(1)   Tp(2)     Tp(3)+d1*Tinf-d2*T(3)^4];
   T = a\b'; Tplot(itime)=T(3); 
end
Tp=T; % update
Qin = Qin - dt*(h*(T(3)-Tinf)+e1*sig*T(3)^4);  
% assume A=1m^2; 
end
plot(time/3600, Tplot); xlabel('time'); ylabel('Tglass')
T' % =  256.0625  256.0625  256.0624K 
Qin                                  % = -8.073e5 J 
dU=L*rho*cv*(T(3)-278) % = -8.073e5 J global energy balance is check!
