clc; clear 
% air ballon expansion due to heating, simple explicit method 
sig = 5.67e-8; e1=0.1; 
dt=0.005; h=2; T(1)=300;  
R=0.287; cv=2.5*R; cp=3.5*R; % gas constant 
r=0.2; V =4*pi*r^3/3; A=4*pi*r*r;
p=101; m=p*V/(R*T(1)); % p and m are kept constant  
Tp=T(1); Tinf=400; time(1)=0; Qtotal=0; 
nt=40; ntp=nt+1; 
for it=2:ntp
time(it)=(it-1)*dt;
c1=dt*h*A/(m*cp); c2=dt*e1*sig*A/(m*cp); 
T(it)=(1-c1)*Tp+c1*Tinf-c2*Tp^4;
Q_conv = dt*h*A*(Tinf-Tp); 
Q_rad = dt*e1*sig*A*Tp^4; 
Qtotal = Qtotal + Q_conv - Q_rad; 
Tp=T(it); % update Tp 
V =m*R*Tp/p; r=(3*V/(4*pi))^(1/3); A=4*pi*r*r; % update A
end 
r % = 0.2115m 
plot(time, T); xlabel('time'); ylabel('T in K'); grid on
Qtotal                              % = 2.1709J 
dU = m*cp*(T(ntp)-T(1)) % = 2.1709J    
