clc; clear
k=400; L = 0.5; D=.004; p=pi*D; Ac=D*D*pi/4; % properties of fin
h=100; T_inf=20; % condition of the ambient air
nx=150; dx=L/nx; dxs=dx*dx; nxp=nx+1; % grid system 
c1=h*p*dxs/(k*Ac); % convenient or important parameters 
Tb=120; % boundary condition at the base 
a=zeros(nxp); b=zeros(1,nxp); % establish zero elements for the sparse matrix.
x=linspace(0,L, nxp); 
% establish x coordinates 
a(1,1)=1; b(1)=Tb; % node 1
for i=2:nx
a(i,i-1)=1; a(i,i)=-(2+c1); a(i,i+1)=1; b(i)=-c1*T_inf; % interior nodes 
end
a(nxp,nx)=-1; a(nxp,nxp)=1; % The tip of the fin is insulated.
T=a\b';
% 
plot(x,T); axis([0 L 15 120]); 
xlabel('x'); ylabel('T'); hold off
qb = k*Ac*(T(1)-T(2))/dx    % = 7.7410; 

%
%qb3 = k*Ac*(1.5*T(1)-2*T(2)+ 0.5*T(3))/dx;   
% Note that a three-point approximation can yield better accuracy, if so desired 
